//priority 1048
//__lib__ lib_common_V02_01
"use strict";

SHINKEN.OBJECT.SeparatorWidgetFormInterface = function () {
};

SHINKEN.OBJECT.SeparatorWidgetFormInterface.prototype = {
    initSeparatorWidgetDefault: function ( user_prefs ) {
        let widget_cf = this.addSpecific( new SHINKEN.OBJECT.CollapseFolderFromData_V3( SHINKEN_PAGE.DEFAULTFORM.COLLAPSE_FOLDER.SEPARATOR._KEY, _( "form.collapse_folder.label." + SHINKEN_PAGE.DEFAULTFORM.COLLAPSE_FOLDER.SEPARATOR._KEY ) ), true );
        if ( !user_prefs || !user_prefs.getValueByKey( [widget_cf.getUUID(), SHINKEN.OBJECT.COLLAPSE.PARAM.IS_OPEN] ) ) {
            widget_cf.addClass( "shinken-close" );
        }
        
        let current_cf = this.addSpecificToChild( this.getCollapseFolder__widgetSeparator__sizes(), widget_cf, true );
        current_cf.addClass( "shinken-collapse-disabled" );
        current_cf = this.addSpecificToChild( this.getCollapseFolder__widgetSeparator__content(), widget_cf, true, true );
        current_cf.addClass( "shinken-collapse-disabled" );
        current_cf = this.addSpecificToChild( this.getCollapseFolder__widgetSeparator__leftArea(), widget_cf, true, true );
        current_cf.addClass( "shinken-collapse-disabled" );
        current_cf = this.addSpecificToChild( this.getCollapseFolder__widgetSeparator__rightArea(), widget_cf, true, true );
        current_cf.addClass( "shinken-collapse-disabled" );
        current_cf = this.addSpecificToChild( this.getCollapseFolder__widgetSeparator__titleArea(), widget_cf, true, true );
        current_cf.addClass( "shinken-collapse-disabled" );
    },
    // ************************************* COLLAPSE FOLDERS *******************************************//
    getCollapseFolder__widgetSeparator__sizes    : function () {
        const to_return = new SHINKEN.OBJECT.CollapseFolderForProperties( SHINKEN_PAGE.DEFAULTFORM.WIDGET.COLLAPSE_FOLDER.DIMENSION_AREA._KEY, _( "grid.mode_edition.form_widget.separator_widget.collapse_folder.cf_dimensions", [DICTIONARY_COMMON_UI] ) );
        
        this.addSpecificToChild( this.factoryProperty__separator( WIDGET.CONST.PARAM.LAYOUTS.SEPARATOR.WIDTH ), to_return );
        this.addSpecificToChild( this.factoryProperty__separator( WIDGET.CONST.PARAM.LAYOUTS.SEPARATOR.HEIGHT ), to_return );
        
        return to_return;
    },
    getCollapseFolder__widgetSeparator__content  : function () {
        const to_return = new SHINKEN.OBJECT.CollapseFolderForProperties( SHINKEN_PAGE.VISUALFORM.WIDGET.COLLAPSE_FOLDER.AREAS._KEY, _( "grid.mode_edition.form_widget.separator_widget.collapse_folder.cf_area", [DICTIONARY_COMMON_UI] ) );
        
        this.addSpecificToChild( this.factoryProperty__separator( WIDGET.CONST.PARAM.LAYOUTS.SEPARATOR.LAYOUT.INFORMATION_TO_DISPLAY.LEFT_AREA.DISPLAYED ), to_return );
        this.addSpecificToChild( this.factoryProperty__separator( WIDGET.CONST.PARAM.LAYOUTS.SEPARATOR.LAYOUT.INFORMATION_TO_DISPLAY.RIGHT_AREA.DISPLAYED ), to_return );
        
        return to_return;
    },
    getCollapseFolder__widgetSeparator__leftArea : function () {
        const to_return = new SHINKEN.OBJECT.CollapseFolderForProperties( SHINKEN_PAGE.VISUALFORM.WIDGET.COLLAPSE_FOLDER.LEFT_AREA._KEY, _( "grid.mode_edition.form_widget.separator_widget.collapse_folder.cf_left_area", [DICTIONARY_COMMON_UI] ) );
        
        this.addSpecificToChild( this.factoryProperty__separator( WIDGET.CONST.PARAM.LAYOUTS.SEPARATOR.LAYOUT.INFORMATION_TO_DISPLAY.LEFT_AREA.WIDTH_PERCENT ), to_return );
        
        return to_return;
    },
    getCollapseFolder__widgetSeparator__rightArea: function () {
        const to_return = new SHINKEN.OBJECT.CollapseFolderForProperties( SHINKEN_PAGE.VISUALFORM.WIDGET.COLLAPSE_FOLDER.RIGHT_AREA._KEY, _( "grid.mode_edition.form_widget.separator_widget.collapse_folder.cf_right_area", [DICTIONARY_COMMON_UI] ) );
        
        this.addSpecificToChild( this.factoryProperty__separator( WIDGET.CONST.PARAM.LAYOUTS.SEPARATOR.LAYOUT.INFORMATION_TO_DISPLAY.RIGHT_AREA.WIDTH_PERCENT ), to_return );
        
        return to_return;
    },
    getCollapseFolder__widgetSeparator__titleArea: function () {
        const to_return = new SHINKEN.OBJECT.CollapseFolderForProperties( SHINKEN_PAGE.VISUALFORM.WIDGET.COLLAPSE_FOLDER.TITLE_AREA._KEY, _( "grid.mode_edition.form_widget.separator_widget.collapse_folder.cf_title_area", [DICTIONARY_COMMON_UI] ) );
        
        this.addSpecificToChild( this.factoryProperty__separator( WIDGET.CONST.PARAM.LAYOUTS.SEPARATOR.LAYOUT.INFORMATION_TO_DISPLAY.TITLE_AREA.TEXT_ALIGN ), to_return );
        this.addSpecificToChild( this.factoryProperty__separator( WIDGET.CONST.PARAM.LAYOUTS.SEPARATOR.LAYOUT.INFORMATION_TO_DISPLAY.TITLE_AREA.TEXT_COLOR ), to_return );
        this.addSpecificToChild( this.factoryProperty__separator( WIDGET.CONST.PARAM.LAYOUTS.SEPARATOR.LAYOUT.INFORMATION_TO_DISPLAY.TITLE_AREA.FONT_ZOOM_PERCENT ), to_return );
        
        return to_return;
    },
    // ******************************************** PROPERTIES ***********************************************//
    factoryProperty__separator: function ( property_structure ) {
        let to_return;
        const mandatory_class = this.getMandatoryClass( property_structure );
        const radios          = this.parseConfigurationToArray( property_structure.OPTIONS, "grid.mode_edition.form_widget." + property_structure.COMPOSED_KEY, property_structure, WIDGET.CONST.PARAM.LAYOUTS.SEPARATOR._KEY );
        
        switch ( property_structure ) {
            case WIDGET.CONST.PARAM.LAYOUTS.SEPARATOR.LAYOUT.INFORMATION_TO_DISPLAY.TITLE_AREA.TEXT_ALIGN:
            case WIDGET.CONST.PARAM.LAYOUTS.SEPARATOR.LAYOUT.INFORMATION_TO_DISPLAY.RIGHT_AREA.DISPLAYED:
            case WIDGET.CONST.PARAM.LAYOUTS.SEPARATOR.LAYOUT.INFORMATION_TO_DISPLAY.LEFT_AREA.DISPLAYED:
                to_return = new PROPERTY.CheckBoxRadioPropFromData_V3( property_structure.COMPOSED_KEY, radios, _( "grid.mode_edition.form_widget." + property_structure.COMPOSED_KEY + ".label", [DICTIONARY_COMMON_UI] ) );
                break;
            case WIDGET.CONST.PARAM.LAYOUTS.SEPARATOR.LAYOUT.INFORMATION_TO_DISPLAY.TITLE_AREA.LABEL:
                to_return = new PROPERTY.StringInputFromData_V3( property_structure.COMPOSED_KEY, "", _( "grid.mode_edition.form_widget." + property_structure.COMPOSED_KEY + ".label", [DICTIONARY_COMMON_UI] ) );
                break;
            case WIDGET.CONST.PARAM.LAYOUTS.SEPARATOR.HEIGHT:
            case WIDGET.CONST.PARAM.LAYOUTS.SEPARATOR.WIDTH:
            case WIDGET.CONST.PARAM.LAYOUTS.SEPARATOR.LAYOUT.INFORMATION_TO_DISPLAY.LEFT_AREA.WIDTH_PERCENT:
            case WIDGET.CONST.PARAM.LAYOUTS.SEPARATOR.LAYOUT.INFORMATION_TO_DISPLAY.RIGHT_AREA.WIDTH_PERCENT:
            case WIDGET.CONST.PARAM.LAYOUTS.SEPARATOR.LAYOUT.INFORMATION_TO_DISPLAY.TITLE_AREA.TEXT_COLOR:
            case WIDGET.CONST.PARAM.LAYOUTS.SEPARATOR.LAYOUT.INFORMATION_TO_DISPLAY.TITLE_AREA.FONT_ZOOM_PERCENT:
                to_return = new PROPERTY.CheckBoxRadioProp__WithStringInput__FromData( property_structure.COMPOSED_KEY, radios, _( "grid.mode_edition.form_widget." + property_structure.COMPOSED_KEY + ".label", [DICTIONARY_COMMON_UI] ) );
                to_return.doActionAfter( "set_placeholder_input_V3", { [ COMPONENT.CONST.PARAM.TEXT_PLACEHOLDER_INPUT ]: _( "grid.mode_edition.form_widget." + property_structure.COMPOSED_KEY + ".input.placeholder", [DICTIONARY_COMMON_UI] ) } );
                break;
        }
        to_return.addClass( mandatory_class );
        this.setValueForProperty( property_structure, to_return, WEATHER.CONST.WIDGET_TYPE.SEPARATOR );
        
        to_return.setPreviousModificationElement();
        return to_return;
    },
    setValueForProperty       : function ( property_structure, property, type ) {
    }
};