//priority 120
//__lib__ lib_common_V02_01
"use strict";

SHINKEN.OBJECT.GridPage           = function ( uuid ) {
    this.__class_name__ = "SHINKEN.OBJECT.GridPage";
    this.init( uuid );
};
SHINKEN.OBJECT.GridPage.prototype = {
    init                 : function ( uuid ) {
        this.initCommon( uuid );
    },
    initCommon           : function ( uuid ) {
        this.uuid                                                    = uuid;
        this.page_version                                            = "-1";
        this[ SHINKEN_PAGE.CONST.PARAM.PAGE.VALIDATION_CHANGE_TIME ] = "-1";
        this.setDomElement( document.querySelector( ".shinken-grid-page-container" ) );
        this.initPhase( "", this.getDomElement() );
        this.bar_info = this.getInfoBarChildConstructor( null, this.getDomElement() );
        this.reset();
        this.initRefresh();
        this.getBackendData__20240926( ( _status, data ) => {
            this.actionsAfterGetData( _status, data );
            this.computeHtml();
        } );
        this._getValidOwnChildren();
    },
    initCounterCommon    : function () {
        this.counters = {};
        this.initCounter( SHINKEN.OBJECT.COUNTER_V2_CONST.TYPE.ERRORS );
        this.initCounter( SHINKEN.OBJECT.COUNTER_V2_CONST.TYPE.WARNINGS );
        this.initCounter( SHINKEN.OBJECT.COUNTER_V2_CONST.TYPE.WIDGET_TOTAL );
    },
    onTimeoutError       : function () {
        this.setPhase( SHINKEN.OBJECT.CONST.PHASE.RUNNING );
        this.refresh_object.setPhase( SHINKEN.OBJECT.CONST.PHASE.RUNNING_TO_STRING );
    },
    onScroll             : function ( event ) {
        this.content.onScroll( event );
    },
    doActionAfter        : function ( event_name, params ) {
    },
    setIdentification    : function ( to_set ) {
        this.page_version                                    = to_set[ SHINKEN_PAGE.CONST.PARAM.PAGE.VERSION ][ "value" ];
        this[ SHINKEN_PAGE.CONST.PARAM.PAGE.IDENTIFICATION ] = to_set;
    },
    setViewBehaviour     : function ( to_set ) {
        const data                                              = {};
        data[ SHINKEN.OBJECT.VIEW.BEHAVIOUR.PARAM.LAST_UPDATE ] = to_set[ SHINKEN.OBJECT.VIEW.BEHAVIOUR.PARAM.LAST_UPDATE ][ SHINKEN_PAGE.CONST.PARAM.SPECIFIC_TREATMENT.OBJECT_VALUE ];
        data[ SHINKEN.OBJECT.VIEW.BEHAVIOUR.PARAM.PHASE ]       = to_set[ SHINKEN.OBJECT.VIEW.BEHAVIOUR.PARAM.PHASE ][ SHINKEN_PAGE.CONST.PARAM.SPECIFIC_TREATMENT.OBJECT_VALUE ];
        
        this.view_behaviour = new SHINKEN.OBJECT.ViewBehaviour();
        this.view_behaviour.setPhaseDomElement( this.getDomElement(), "viewBehaviour" );
        this.view_behaviour.updateData( data );
        SHINKEN.COMMUNICATION_WITH_IFRAME_PARENT.doActionAfter( "update_screen_with_view_behaviour", this.view_behaviour );
    },
    getChildrenObject    : function () {
        const _to_return = this.content.getChildrenObject();
        _to_return.push( this.users );
        _to_return.push( this.notifications );
        return _to_return;
    },
    getChildrenObjectDict: function () {
        const _to_return                                       = this.content.getChildrenObjectDict();
        _to_return[ SHINKEN_PAGE.CONST.PARAM.PAGE.USERS._KEY ] = this.users || new SHINKEN.OBJECT.UserGrids();
        //_to_return[ SHINKEN_PAGE.CONST.PARAM.PAGE.NOTIFICATIONS._KEY ] = this.notifications || new WEATHER.Notifications(); // TODO Est ce que c'est uniquement pour la weather ?
        return _to_return;
    },
    _getValidOwnChildren : function () {
        return new SHINKEN.OBJECT.DefaultConfigurationChildren( [
            [WEATHER.CONST.EXTERNAL_LINKS.PARAM.DEFAULT_LINK._KEY, "SHINKEN.OBJECT.DefaultConfigurationPageDefault"]
        ] );
    },
    //********************************************  GETTER SETTER  *****************************************************//
    getUUID                   : function () {
        return this.uuid;
    },
    getPageVersion            : function () {
        return this.page_version;
    },
    getInfoBarChildConstructor: function ( data, parent_dom_element ) {
        return new SHINKEN_PAGE.InfoBar( data, parent_dom_element );
    },
    //********************************************  COMPUTE  *****************************************************//
    computeSizes: function () {
        this.content.computeSizes();
    },
    //********************************************  REFRESH  *****************************************************//
    initRefresh: function () {
        this.refresh_object = new SHINKEN.OBJECT.Refresh( 60000, this );
        this.refresh_object.addUiComponent( new SHINKEN.TOOLS.ClockComponent() );
        this.refresh_object.addUiComponent( new SHINKEN.TOOLS.UpdateAtComponent() );
    },
    //********************************************  OTHERS  *****************************************************//
    refresh                        : function () {
        const _self = this;
        this.getBackendData__20240926( function ( _status, data ) {
            _self.actionsAfterGetData( _status, data );
        } );
    },
    actionsAfterGetData            : function ( _status, data ) {
        this.updateUserPrefsFromBackendData();
        this.updateObject( data[ "output" ], true );
        this.setPhase( SHINKEN.OBJECT.CONST.PHASE.RUNNING );
        this.askComputeNotificationOfChange();
        SHINKEN.COMMUNICATION_WITH_IFRAME_PARENT.doActionAfter( "iframe_grid_page_view_has_been_refreshed" );
    },
    getDefaultNotificationsOfChange: function ( actions_after_get_user_prefs ) {
    },
    updateUserPrefsFromBackendData : function () {
        if ( !__has_authentication_needed__ ) {
            this.getDefaultNotificationsOfChange( ( _status, data ) => {
                this.default_notifications_of_changed.updateData( data );
                this.askComputeNotificationOfChange();
            } );
            return;
        }
        const actionAfterGetUsersPrefsSuccess = ( _status, data ) => {
            this.user_prefs.updateData( data );
            this.getDefaultNotificationsOfChange( ( _status, data ) => {
                this.default_notifications_of_changed.updateData( data );
                this.askComputeNotificationOfChange();
            } );
        };
        this.getUserPrefs( actionAfterGetUsersPrefsSuccess );
    },
    getUserPrefs                   : function ( actions_after_get_user_prefs ) {
        const url                             = SHINKEN.HIGHWAY.getOrigin() + COMMUNICATION.QUERY.GET.USER.GET_USER_PREFERENCES;
        const actionsAfterGetUserPrefsSuccess = function ( _status, data ) {
            actions_after_get_user_prefs( _status, data );
        };
        SHINKEN.COMUNICATION.requestGet( url, actionsAfterGetUserPrefsSuccess );
    },
    getController                  : function () { // TO OVERRIDE
        throw new Error( "getController of SHINKEN.OBJECT.GridPage need to be override" );
    },
    getBackendData__20240926       : function ( actions_after_get_data, need_user_value ) {
        const url                               = this.getBackendDataUrl__20241008( need_user_value );
        const actionsAfterGetBackendDataSuccess = ( _status, data ) => {
            switch ( data.rc ) {
                case COMMUNICATION.CODE.ERROR :
                    this.getController().doActionAfter400();
                    break;
                case COMMUNICATION.CODE.NOT_FOUND:
                    this.getController().doActionWhenNotFound();
                    break;
                case COMMUNICATION.CODE.FORBIDDEN:
                    this.getController().doActionAfter403();
                    break;
                default:
                    actions_after_get_data( _status, data );
                    break;
            }
        };
        SHINKEN.COMUNICATION.requestGet( url, actionsAfterGetBackendDataSuccess, this.getController().onTimeoutError, this.getController().doActionWhenNotFound );
    },
    getBackendDataUrl__20241008    : function () {// TO OVERRIDE
        throw new Error( "getBackendDataUrl of SHINKEN.OBJECT.GridPage need to be override" );
    },
    //********************************************  PHASE  *****************************************************//
    callbackForPhase: function () {
        const _current_phase = this.getCurrentPhase();
        switch ( _current_phase ) {
            case SHINKEN.OBJECT.CONST.PHASE.RUNNING:
                this.content.setPhase( _current_phase );
                this.refresh_object.setPhase( SHINKEN.OBJECT.CONST.PHASE.RUNNING_TO_STRING );
                this.getController().askCloseLoadingPage();
                if ( this.getPreviousPhase() === SHINKEN.OBJECT.CONST.PHASE.RUNNING_TO_STRING ) {
                    this.doActionAfter( "ask_play_notifications", this.default_notifications_of_changed.getFlatUserVolume( this.user_prefs.getNotificationOfChange() ) );
                }
                break;
            case SHINKEN.OBJECT.CONST.PHASE.REFRESHING:
                this.refresh_object.setPhase( SHINKEN.OBJECT.CONST.PHASE.REFRESHING_TO_STRING );
                break;
            case SHINKEN.OBJECT.CONST.PHASE.HIDDEN:
                this.refresh_object.setPhase( SHINKEN.OBJECT.CONST.PHASE.HIDDEN_TO_STRING );
                break;
            default:
                break;
        }
    },
    //********************************************  UPDATE DATA   **************************************************//
    reset                  : function () { // TO OVERRIDE
        console.warn( "CPOU", "[Page - reset]", "[]" );
    },
    saveJsHistory          : function () {
        //nothing to do if not edit
        return false;
    },
    updateObject           : function ( data, skip_history ) {
        if ( data[ SHINKEN_PAGE.CONST.CONFIGURATION_ID_IS_OUTDATED ] ) {
            SHINKEN.HIGHWAY.refreshCurrentPage();
            return;
        }
        this.initMessages();
        
        const _keys     = Object.keys( data );
        const _sizeData = _keys.length;
        let _currentKey;
        let _value;
        if ( data[ SHINKEN_PAGE.CONST.PARAM.SPECIFIC_TREATMENT.OBJECT_VALUE ] ) {
            this.doActionAfter( "before__update_object__grid_page" );
            this.updateData( data[ SHINKEN_PAGE.CONST.PARAM.SPECIFIC_TREATMENT.OBJECT_VALUE ] ); // The object must be updated before getting the remaining
        }
        for ( let i = 0; i < _sizeData; i++ ) {
            _currentKey = _keys[ i ];
            _value      = data[ _currentKey ];
            switch ( _currentKey ) {
                case SHINKEN.OBJECT.CONST.VALIDATION.FIELD.MESSAGES:
                    this.setMessages( _value );
                    break;
                case SHINKEN_PAGE.CONST.PARAM.PAGE.ELEMENTS_DATA:
                    this.content.setData( _currentKey, _value );
                    break;
                case SHINKEN_PAGE.CONST.PARAM.PAGE.CURRENT_INFO_BAR:
                    this.bar_info.updateData( _value );
                    break;
                case SHINKEN_PAGE.CONST.PARAM.PAGE.CURRENT_NOTIFICATIONS:
                    this.bar_info.doActionAfter( "update__notification_of_change__data", { [ SHINKEN_PAGE.CONST.EVENTS.PARAM.NOTIFICATIONS_OF_CHANGE__DATA ]: _value[ SHINKEN_PAGE.CONST.PARAM.SPECIFIC_TREATMENT.OBJECT_VALUE ] } );
                    this.askComputeNotificationOfChange();
                    break;
                case SHINKEN_PAGE.CONST.PARAM.PAGE.AUTHENTICATION_NEEDED:
                    if ( this[ _currentKey ] !== undefined && _value !== this[ _currentKey ] ) {
                        SHINKEN.HIGHWAY.refreshCurrentPage();
                    }
                    this[ _currentKey ] = _value;
                    break;
                case SHINKEN_PAGE.CONST.PARAM.PAGE.LAST_ELEMENT_DATA_FETCH:
                    if ( this.refresh_object ) {
                        this.refresh_object.setLastComputeDate( _value );
                    }
                    break;
                case SHINKEN_PAGE.CONST.PARAM.PAGE.VALIDATION_CHANGE_TIME:
                    this[ _currentKey ] = _value;
                    break;
                case SHINKEN_PAGE.CONST.PARAM.PAGE.USER_IS_ADMIN:
                    __user_is_admin__ = _value;
                    break;
                case "_id":
                    break;
                //default:
                //    console.warn("GSOU", "[Page - updateObject]", _currentKey, _value );
                //    break;
            }
        }
        if ( !skip_history ) {
            this.saveJsHistory( data );
        }
    },
    getDefaultValueFor     : function ( type, key ) {
        const dict = this.getDefaultFromType( type ).getDataForJson( SHINKEN.OBJECT.JSON_EDITOR.FORMAT_DATA.VALUE_AND_DEFAULT_AND_CFG );
        return SHINKEN.TOOLS.DICT.getValueWithComposedKey( dict, key );
    },
    getDefaultFromType     : function ( type ) {
        return this[ type ][ WEATHER.CONST.EXTERNAL_LINKS.PARAM.DEFAULT_LINK._KEY ];
    },
    computeWidgetWithChange: function () {
        this.size_widget_with_change = this.content.computeWidgetWithChange();
    },
    setData                : function ( key, value ) {
        this.setDataCommon( key, value );
    },
    setDataCommon          : function ( key, value ) {
        switch ( key ) {
            case SHINKEN_PAGE.CONST.PARAM.PAGE.GRIDS:
                this.content.setData( key, value );
                break;
            case SHINKEN_PAGE.CONST.PARAM.PAGE.USERS._KEY:
                this.users = new SHINKEN.OBJECT.UserGrids( value );
                break;
            case SHINKEN.OBJECT.VIEW.PARAM.VIEW_BEHAVIOUR:
                this.setViewBehaviour( value[ SHINKEN_PAGE.CONST.PARAM.SPECIFIC_TREATMENT.OBJECT_VALUE ] );
                break;
            case SHINKEN_PAGE.CONST.PARAM.PAGE.TYPE:
            case SHINKEN_PAGE.CONST.PARAM.PAGE.WEATHER_UUID:
                this[ key ] = value;
                break;
            case SHINKEN_PAGE.CONST.PARAM.PAGE.IDENTIFICATION:
                this.setIdentification( value[ SHINKEN_PAGE.CONST.PARAM.SPECIFIC_TREATMENT.OBJECT_VALUE ] );
                break;
            case SHINKEN_PAGE.CONST.PARAM.PAGE.NOTIFICATIONS._KEY:
                this.notifications = new WEATHER.Notifications( value );// TODO EST ce que c'est spécifique a la Weather ?
                break;
            default:
                this.setDataAsUnknownProperty( key, value );
                break;
        }
    },
    //********************************************  HTML   **************************************************//
    computeHtml: function () {
        this.refresh_object.computeHtml();
        this.bar_info.computeHtml( this.refresh_object );
        this.getDomElement().dataset.infoBarPosition = this.bar_info.getPosition();
    }
};
SHINKEN.TOOLS.CLASS.addPrototype( SHINKEN.OBJECT.GridPage, SHINKEN.OBJECT.PhaseInterface );
SHINKEN.TOOLS.CLASS.addPrototype( SHINKEN.OBJECT.GridPage, SHINKEN.OBJECT.ShinkenObjectHtml );
SHINKEN.TOOLS.CLASS.addPrototype( SHINKEN.OBJECT.GridPage, SHINKEN.OBJECT.DefaultConfigurationWithOwnProperty );