//__lib__ lib_common_V02_01
"use strict";

SHINKEN_PAGE.InfoBar = function ( data, dom_element_parent ) {
    this.__class_name__ = "SHINKEN_PAGE.InfoBar";
    this.initCommon( data, dom_element_parent );
};

SHINKEN_PAGE.InfoBar.prototype = {
    initCommon: function ( data, dom_element_parent ) {
        this.init( data );
        if ( dom_element_parent ) {
            this.dom_element_parent = dom_element_parent.querySelector( ".shinken-info-bar-container" );
        }
    },
    //********************************************  EVENT LISTENER  *****************************************************//
    doActionAfter      : function ( event_name, params ) {
        this.doActionAfterCommon( event_name, params );
    },
    doActionAfterCommon: function ( event_name, params ) {
    },
    //********************************************  GETTER SETTER  *****************************************************//
    _getValidOwnProperty: function () {
        return new SHINKEN_VALIDATION.Parameters( [
            [SHINKEN_PAGE.CONST.INFO_BAR.PARAMS.BACKGROUND_COLOR, SHINKEN_VALIDATION.CONST.COLOR.CSS._KEY],
            [SHINKEN_PAGE.CONST.INFO_BAR.PARAMS.LOGO_DISPLAYED, SHINKEN_VALIDATION.CONST.BOOLEAN._KEY],
            [SHINKEN_PAGE.CONST.INFO_BAR.PARAMS.POSITION, SHINKEN_VALIDATION.CONST.LIST.INCLUDE_IN, ["top", "bottom", SHINKEN_PAGE.CONST.DEFAULT_VALUE]]
        ] );
    },
    _getValidOwnChildren: function () {
        return new SHINKEN.OBJECT.DefaultConfigurationChildren( [
            [SHINKEN_PAGE.CONST.INFO_BAR.PARAMS.REFRESH, "SHINKEN_PAGE.InfoBarRefresh"]
        ] );
    },
    getPosition         : function () {
        if ( !this.getChild( SHINKEN_PAGE.CONST.INFO_BAR.PARAMS.REFRESH ).getValue( SHINKEN_PAGE.CONST.INFO_BAR.PARAMS.GENERATION_TIME_DISPLAYED ) &&
             !this.getValue( SHINKEN_PAGE.CONST.INFO_BAR.PARAMS.LOGO_DISPLAYED ) &&
             !this.getChild( SHINKEN_PAGE.CONST.INFO_BAR.PARAMS.REFRESH ).getValue( SHINKEN_PAGE.CONST.INFO_BAR.PARAMS.CHRONO_DISPLAYED ) ) {
            return "shinken-hidden";
        }
        if ( this.getValue( SHINKEN_PAGE.CONST.INFO_BAR.PARAMS.POSITION ) === SHINKEN_PAGE.CONST.INFO_BAR.VALUES.POSITION_BOTTOM ) {
            return "bottom";
        }
        else {
            return "top";
        }
    },
    //********************************************  HTML  *****************************************************//
    computeHtml               : function ( refresh_object ) {
        this.setDomElement( DOM.Service.createElement( "div", { class: "shinken-info-bar" } ) );
        DOM.Service.addElementTo( this.getDomElement(), this.dom_element_parent );
        
        if ( __external_url_uuid__ ) {
            DOM.Service.setStyle( this.getDomElement(), DOM.CONST.STYLE.BACKGROUND_COLOR, this.getValue( SHINKEN_PAGE.CONST.INFO_BAR.PARAMS.BACKGROUND_COLOR ) );
        }
        this.computeHtml__logo();
        this.left_positioned_dom = this.addDomElement( DOM.Service.createElement( "div", { class: "shinken-left-positioned shinken-layout-center-v" } ) );
        
        this.computeHtml__editionButton();
        this.computeHtml__extraContent();
        this.computeHtml__refresh( refresh_object );
    },
    computeHtml__logo         : function () {
        let container_logo = this.addDomElement( DOM.Service.createElement( "div", { class: "shinken-logo-container shinken-user-select-none" } ) );
        if ( !__external_url_uuid__ ) {
            DOM.Service.addElementTo( DOM.Service.createElement( "div", { class: "shinken-space-left" } ), container_logo );
            DOM.Service.addElementTo( DOM.Service.cloneElement( document.querySelector( "#id-shinken-template-view .shinken-weather-icon" ) ), container_logo );
            DOM.Service.addElementTo( DOM.Service.createElement( "div", { class: "shinken-rounded-space-right" } ), container_logo );
            return;
        }
        if ( __external_url_uuid__ && this.getBooleanValue( SHINKEN_PAGE.CONST.INFO_BAR.PARAMS.LOGO_DISPLAYED ) ) {
            DOM.Service.addElementTo( DOM.Service.createElement( "img", { class: "shinken-logo", src: "/static/" + __SHINKEN_HTTP_START_TIME__ + "/common_ui/img/logos/shinken_logo_black.png", alt: "shinken-logo" } ), container_logo );
        }
    },
    computeHtml__editionButton: function () {
        if ( !__external_url_uuid__ && __user_is_admin__ ) {
            let container_button        = DOM.Service.addElementTo( DOM.Service.createElement( "div", { class: "shinken-button-container shinken-weather-edit-mode-button-cell" } ), this.left_positioned_dom );
            this.button_enter_edit_mode = new COMPONENT.ButtonFromData_V3( "enter_in_edit_mode", _( "edit_mode.buttons.edit_mode" ) );
            this.button_enter_edit_mode.computeHtml();
            DOM.Service.addElementTo( this.button_enter_edit_mode.getDomElement(), container_button );
            DOM.Service.addElementTo( DOM.Service.createElement( "div", { class: "shinken-weather-popup-progress-bar-container" } ), container_button );
        }
    },
    computeHtml__extraContent : function () {
    },
    computeHtml__refresh      : function ( refresh_object ) {
        if ( this.getChild( SHINKEN_PAGE.CONST.INFO_BAR.PARAMS.REFRESH ).getBooleanValue( SHINKEN_PAGE.CONST.INFO_BAR.PARAMS.GENERATION_TIME_DISPLAYED ) ) {
            DOM.Service.addElementTo( refresh_object.getSpecificDomElement( SHINKEN.OBJECT.Refresh.CONST.UPDATE_AT ), this.left_positioned_dom );
        }
        
        if ( this.getChild( SHINKEN_PAGE.CONST.INFO_BAR.PARAMS.REFRESH ).getBooleanValue( SHINKEN_PAGE.CONST.INFO_BAR.PARAMS.CHRONO_DISPLAYED ) ) {
            DOM.Service.addElementTo( refresh_object.getSpecificDomElement( SHINKEN.OBJECT.Refresh.CONST.CLOCK ), this.left_positioned_dom );
        }
    }
};
SHINKEN.TOOLS.CLASS.addPrototype( SHINKEN_PAGE.InfoBar, SHINKEN.OBJECT.DefaultConfigurationWithOwnPropertyGridPage );
SHINKEN.TOOLS.CLASS.addPrototype( SHINKEN_PAGE.InfoBar, SHINKEN.OBJECT.ShinkenObjectHtml );


SHINKEN_PAGE.InfoBarRefresh = function ( data ) {
    this.init( data );
};

SHINKEN_PAGE.InfoBarRefresh.prototype = {
    init: SHINKEN.OBJECT.DefaultConfigurationWithOwnPropertyGridPage.prototype.init,
    //********************************************  GETTER SETTER  *****************************************************//
    _getValidOwnProperty: function () {
        return new SHINKEN_VALIDATION.Parameters( [
            [SHINKEN_PAGE.CONST.INFO_BAR.PARAMS.CHRONO_DISPLAYED, SHINKEN_VALIDATION.CONST.BOOLEAN._KEY],
            [SHINKEN_PAGE.CONST.INFO_BAR.PARAMS.GENERATION_TIME_DISPLAYED, SHINKEN_VALIDATION.CONST.BOOLEAN._KEY]
        ] );
    }
};
SHINKEN.TOOLS.CLASS.addPrototype( SHINKEN_PAGE.InfoBarRefresh, SHINKEN.OBJECT.DefaultConfigurationWithOwnPropertyGridPage );