//priority 20
//__lib__ lib_common_V02_01
"use strict";
WINDOW_V2.Element           = function ( window_name, parent_name ) {
    this.__class_name__ = "WINDOW_V2.Element";
    this.init( window_name, parent_name );
};
WINDOW_V2.Element.prototype = {
    init          : function ( window_name, parent_name ) {
        this.initCommon( window_name, parent_name );
    },
    initCommon    : function ( window_name, parent_name ) {
        this.initCounterCommon();
        this.name        = window_name;
        this.parent_name = parent_name;
        this.addParamForEvents( WINDOW_V2.CONST.PARAM.WINDOW_NAME, this.name );
        this.addParamForEvents( WINDOW_V2.CONST.PARAM.WINDOW_GROUP_NAME, this.parent_name );
        this.uuid = WINDOW_V2.CONST.ID.WINDOW_TAB + this.name;
        if ( this.parent_name ) {
            this.uuid = this.uuid + "-" + this.parent_name;
        }
        this.initPhase();
    },
    initController: function () {
        let controller = this.getController_20240426();
        if ( controller ) {
            controller.init();
        }
    },
    //********************************************  EVENT LISTENER  **************************************************//
    doActionAfter      : function ( event_name, param ) {
        this.doActionAfterCommon( event_name, param );
    },
    doActionAfterCommon: function ( event_name, param ) {
        switch ( event_name ) {
            case "compute_html_done":
                this.setPhaseDomElement( this.getDomElement() );
                break;
            case "init_controller":
                this.initController();
                break;
        }
    },
    //********************************************  SETTER GETTER   **************************************************//
    getController_20240426    : function () {
        return CONTROLLER.UiViewWeatherManager;
    },
    getName                   : function () {
        return this.name;
    },
    getParentName             : function () {
        return this.parent_name;
    },
    getLabel                  : function () {
        return this.label || this.name;
    },
    getUUID                   : function () {
        return this.uuid;
    },
    setActiveWindow           : function ( window_name ) {
        if ( this.getName() === window_name ) {
            this.setPhase( SHINKEN.OBJECT.CONST.PHASE.RUNNING_TO_STRING );
            return true;
        }
        else {
            this.setPhaseIfPhase( SHINKEN.OBJECT.CONST.PHASE.STOPPING, SHINKEN.OBJECT.CONST.PHASE.RUNNING_TO_STRING );
        }
        return false;
    },
    isClickable               : function () {
        var current_phase = this.getCurrentPhase();
        switch ( current_phase ) {
            case SHINKEN.OBJECT.CONST.PHASE.RUNNING_TO_STRING:
            case SHINKEN.OBJECT.CONST.PHASE.HIDDEN_TO_STRING:
                return false;
        }
        switch ( this.visibility_state ) {
            case SHINKEN.CONST.VISIBILITY_STATE.HIDDEN:
            case SHINKEN.CONST.VISIBILITY_STATE.DISABLED:
            case SHINKEN.CONST.VISIBILITY_STATE.LOCKED:
            case SHINKEN.CONST.VISIBILITY_STATE.TOTALLY_FORM_EXCLUDE:
                return false;
        }
        return true;
    },
    setContentDomElementTarget: function ( to_set ) {
        this.content_dom_element_target = to_set;
        DOM.Service.addElementToAfterEmpty( this.content_dom_element_target, this.dom_element_target );
    },
    //********************************************  PHASE   **************************************************//
    callbackForPhase: function () {
        var current = this.getCurrentPhase();
        if ( !this.dom_element_target ) {
            return;
        }
        switch ( current ) {
            case SHINKEN.OBJECT.CONST.PHASE.RUNNING_TO_STRING:
                this.dom_element_target.classList.remove( "shinken-hidden" );
                break;
            case SHINKEN.OBJECT.CONST.PHASE.STOPPING:
                this.dom_element_target.classList.add( "shinken-hidden" );
                break;
        }
    }
};
SHINKEN.TOOLS.CLASS.addPrototype( WINDOW_V2.Element, SHINKEN.OBJECT.CounterInterfaceV2 );
SHINKEN.TOOLS.CLASS.addPrototype( WINDOW_V2.Element, SHINKEN.OBJECT.PhaseInterface );
SHINKEN.TOOLS.CLASS.addPrototype( WINDOW_V2.Element, SHINKEN.OBJECT.ShinkenObjectHtml );

WINDOW_V2.ElementWithComma           = function ( window_name, parent_name ) {
    this.init( window_name, parent_name );
};
WINDOW_V2.ElementWithComma.prototype = {
    init: WINDOW_V2.Element.prototype.init,
    //********************************************  EVENT LISTENER  **************************************************//
    doActionAfter             : function ( event_name, param ) {
        this.doActionAfterSpecificComma( event_name, param );
        this.doActionAfterCommon( event_name, param );
    },
    doActionAfterSpecificComma: function ( event_name, param_1, param_2, param_3 ) {
        switch ( event_name ) {
            case "compute_html_done":
                var start_div = DOM.Service.addElementAtIndex( DOM.Service.createElement( "div", { class: "shinken-div-round-part-1" } ), this.main_div_dom_element, 0 );
                var start_svg = DOM.Service.createElement( "div", {}, WINDOW_V2.CONST.SVG.COMMA_SHADOW_LEFT );
                DOM.Service.addElementTo( start_svg.firstChild, start_div );
                
                var end_div = DOM.Service.addElementTo( DOM.Service.createElement( "div", { class: "shinken-div-round-part-2" } ), this.main_div_dom_element );
                var end_svg = DOM.Service.createElement( "div", {}, WINDOW_V2.CONST.SVG.COMMA_SHADOW_RIGHT );
                DOM.Service.addElementTo( end_svg.firstChild, end_div );
                break;
        }
    }
};
SHINKEN.TOOLS.CLASS.addPrototype( WINDOW_V2.ElementWithComma, WINDOW_V2.Element );