//priority 25
//__lib__ lib_common_V02_01
"use strict";

WINDOW_V2.ElementGroupFromData           = function ( group_name ) {
    this.init( group_name );
};
WINDOW_V2.ElementGroupFromData.prototype = {
    init        : WINDOW_V2.ElementGroup.prototype.init,
    initWithData: function ( data_windows ) {
        for ( let i = 0, _size_i = data_windows.length; i < _size_i; i++ ) {
            let added = this.addSpecific( this.getChildConstructor( data_windows[ i ].name, this.getName() ) );
            if ( data_windows[ i ].is_active ) {
                this.setActiveWindow( data_windows[ i ].name );
            }
            if ( data_windows[ i ].label ) {
                added.label.updateLabel( data_windows[ i ].label );
            }
        }
    },
    //********************************************  GETTER SETTER  **************************************************//
    getChildConstructor: function ( window_name, parent_name ) {
        return new WINDOW_V2.ElementFromData( window_name, parent_name );
    },
    //********************************************  HTML  *****************************************************//
    computeHtml        : function () {
        
        this.setDomElement( DOM.Service.createElement( "div", this.getMainAttribute() ) );
        if ( this.getController__20240819() ) {
            this.addParamForEvents( CONTROLLER.CONST.CONTROLLER_NAME_LABEL, this.getController__20240819().controller_name );
        }
        for ( var i = 0, _size_i = this.contents.length; i < _size_i; i++ ) {
            this.contents[ i ].computeHtml();
            this.addDomElement( this.contents[ i ].getDomElement() );
        }
        this.doActionAfter( "compute_html_done" );
    },
    computeHtmlTargets : function ( dom_parent ) {
        this.dom_element_targets = DOM.Service.addElementTo( DOM.Service.createElement( "div", { "class": WINDOW_V2.CONST.CLASS.WINDOW_TARGETS } ), dom_parent );
        for ( var i = 0, _size_i = this.contents.length; i < _size_i; i++ ) {
            this.contents[ i ].computeHtmlTarget();
            DOM.Service.addElementTo( this.contents[ i ].dom_element_target, this.dom_element_targets );
        }
    },
    getMainAttribute   : function () {
        var _to_return            = { "class": this.getMainClass() };
        _to_return[ "data-name" ] = this.getName();
        _to_return[ "onclick" ]   = this.getEventManager();
        if ( this.controller_name ) {
            _to_return[ "data-controller" ] = this.controller_name;
        }
        return _to_return;
    },
    getEventManager   : function () {
        return  "MANAGER.EventManagerV2.clickOnWindowNavigation(event, " + this.parseParamForEventsToHtml() + ")";
    },
    getMainClass       : function () {
        var _to_return = WINDOW_V2.CONST.CLASS.WINDOW_GROUP + " " + this.getClass();
        if ( this.controller_name ) {
            _to_return += " shinken-parent-event-listener";
        }
        return _to_return;
    }
};
SHINKEN.TOOLS.CLASS.addPrototype( WINDOW_V2.ElementGroupFromData, WINDOW_V2.ElementGroup );

WINDOW_V2.ElementGroupFromDataWithComma           = function ( group_name ) {
    this.init( group_name );
};
WINDOW_V2.ElementGroupFromDataWithComma.prototype = {
    init         : WINDOW_V2.ElementGroupFromData.prototype.init,
    doActionAfter: WINDOW_V2.ElementGroupWithComma.prototype.doActionAfter,
    //********************************************  GETTER SETTER  **************************************************//
    getChildConstructor: function ( window_name, parent_name ) {
        return new WINDOW_V2.ElementFromDataWithComma( window_name, parent_name );
    }
};
SHINKEN.TOOLS.CLASS.addPrototype( WINDOW_V2.ElementGroupFromDataWithComma, WINDOW_V2.ElementGroupFromData );
SHINKEN.TOOLS.CLASS.addPrototype( WINDOW_V2.ElementGroupFromDataWithComma, WINDOW_V2.ElementGroupWithComma );
