#!/usr/bin/python
# -*- coding: utf-8 -*-
#
# Copyright (C) 2013-2024:
# This file is part of Shinken Enterprise, all rights reserved.


from abc import ABCMeta, abstractmethod


class View(metaclass=ABCMeta):
    
    @abstractmethod
    def get_uuid(self) -> str:
        ...
    
    
    @abstractmethod
    def get_name(self) -> str:
        ...
    
    
    @abstractmethod
    def get_view_type(self) -> str:
        ...
